/*
 * CS 3114 Project 1
 * Author: Kevin Lee
 * Compiler: Eclipse 3.7.0
 * Operating System: Windows 7 x64
 * Date Completed: 9/1/2011
 * 
 * The following program is designed to provide an interface to
 * client side code that allows the client to store and retrieve
 * byte arrays of data. The memory manager has no information on
 * the actual data to be stored, other than the size of the byte
 * array. The memory manager allocates a memory pool when the
 * object is created, and executes all operations on the memory
 * pool. The memory manager also keeps a doubly linked list of
 * empty blocks from which it finds the best fit block to store
 * the passed data in. The client is responsible for parsing the
 * command file as well as creating the byte array holding the 
 * data to be stored. The client also has a record array which
 * stores handles passed back from the memory manager from which
 * it uses to retrieve stored data from the memory manager.
 * 
 * The stored data is saved in the following format:
 * byte[0] = size of data record
 * byte[1-4] = int (x-coordinate)
 * byte[5-8] = int (y-coordinate)
 * byte[9-?] = string (name of city name)
 * The first byte is only used by the memory manager and is not
 * returned to the client when the data record is retrieved.
 * 
 * On my honor:
 *
 * - I have not used source code obtained from another student,
 * or any other unauthorized source, either modified or
 * unmodified.
 *
 * - All source code and documentation used in my program is
 * either my original work, or was derived by me from the
 * source code published in the textbook for this course.
 *
 * - I have not discussed coding details about this project with
 * anyone other than my partner (in the case of a joint
 * submission), instructor, ACM/UPE tutors or the TAs assigned
 * to this course. I understand that I may discuss the concepts
 * of this program with other students, and that another student
 * may help me debug my program so long as neither of us writes
 * anything during the discussion or modifies any computer file
 * during the discussion. I have violated neither the spirit nor
 * letter of this restriction.
 */
import java.io.*;

public class memman {
	public static void main(String[] args) {

		int input_poolSize; // Size of memory pool to allocate
		int input_numRecs; // Total number of records to hold
		String input_commandFile; // Location of file to parse

		// 3 arguments must be supplied to the program
		if (args.length != 3) {
			System.out.println("3 Arguments must be supplied!");
			return;
		}

		// Parses passed arguments into member variables
		try {
			input_poolSize = Integer.parseInt(args[0]);
			input_numRecs = Integer.parseInt(args[1]);
			input_commandFile = args[2];
		} catch (NumberFormatException e) {
			System.out.printf("The first two arguments must be an integer");
			return;
		}

		// Handles error if the passed arguments are negative numbers
		if (input_poolSize < 0 || input_numRecs < 0) {
			System.out.printf("Int arguments cannot be negative");
			return;
		}

		// Check to make sure the command file exists
		File cmdFile = new File(input_commandFile);
		if (!cmdFile.exists()) {
			System.out.printf("Command file not found");
			return;
		}
		
		MemClient memoryClient = new MemClient(input_numRecs, input_poolSize);
		
		// Parse each command with the memory client
		try {
			BufferedReader reader = new BufferedReader(new FileReader(cmdFile));
			String cin;
			while ((cin = reader.readLine()) != null) {
				cin = cin.trim();
				if (cin.length() != 0) {
					memoryClient.processLine(cin);
				}
			}
		} catch (FileNotFoundException e) {
			System.out.printf("Command file not found");
			return;
		} catch (IOException e) {
			System.out.printf("Unable to read input file");
			return;
		}
	}
}
